// Copyright (c) 1998-2005 B2C2, Incorporated.  All Rights Reserved.
//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF B2C2, INCORPORATED.
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
//
// This file is proprietary source code of B2C2, Incorporated. and is released pursuant to and
// subject to the restrictions of the non-disclosure agreement and license contract entered
// into by the parties.
//
//
// B2FilterGraphHandler.h: interface for the CB2FilterGraphHandler class.
//
///////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_B2FILTERGRAPHHANDLER_H__CF8774DE_4EB9_48B8_87C2_A1BF4B665C1D__INCLUDED_)
#define AFX_B2FILTERGRAPHHANDLER_H__CF8774DE_4EB9_48B8_87C2_A1BF4B665C1D__INCLUDED_

#include "b2c2mpeg2adapter.h"
#include "b2c2_defs.h"
#include "ib2c2mpeg2timeshiftctrl.h"
#include "ib2c2mpeg2avctrl.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef interface IVideoWindow			IVideoWindow;


///////////////////////////////////////////////////////////////////////////////
class CB2FilterGraphHandler : public B2C2MPEG2Adapter  
{
public: // Construction/Destruction
	CB2FilterGraphHandler();
	virtual ~CB2FilterGraphHandler();

public: // Virtual base class methods
	virtual void Release();

public: // Methods

	void Pause();
	void Stop();
	void Run();

	void SetVideoWindow(HWND hVideoWnd);
	void UpdateVideoSize(HWND hVideoWnd);

	void AddPIDsToPin(long * plNumPID, long * plPIDArray, long lDataPinIndex);
	void DeletePIDsFromPin(long * plNumPID, long * plPIDArray, long lDataPinIndex);
	void SetSatellite(long lFrequencyKHz, long lLnbFrequencyMHz, 
					  long lSymbolRate, 
					  eLNBSelection eLnbSelectionVal,
					  ePolarity ePolarityVal, 
					  eDiseqc eDiseqcVal = DISEQC_NONE,
					  eFEC eFecVal = FEC_AUTO);
	void SetTerrestiralAtsc(long lFrequencyKHz);

	void GetTsOutPin(int nPin, IPin **ppTsOutPin = NULL);
	void GetAudioVideoOutPins(IPin **ppPinOutAudio = NULL, IPin **ppPinOutVideo = NULL);

	void RenderAudioVideoPins();

	void Initialize();

	void SetAudioVideoPids(long lAudioPid, long lVideoPID);

	void ReleaseVideoWindow();

private: // Variables

	IVideoWindow			*m_pIVideoWnd;
	
	bool m_bFilterGraphRendered;

	bool m_bAudioOnly;

};

#endif // !defined(AFX_B2FILTERGRAPHHANDLER_H__CF8774DE_4EB9_48B8_87C2_A1BF4B665C1D__INCLUDED_)
